using System;
using System.Data;
using System.Reflection;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.BOL
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/4/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>Summary description for RackLot.</summary>

		#endregion

	public class RackLot : BaseBusinessObject
	{
		private BOL.Reagent _reagent;
		private BOL.Rack _rack;
		private Guid _rackLotGUID;
		private bool _satisfactoryResultIndicator;
		private string _reactivityPhaseText;
		private string _reactivityPhaseCode;
		private string _expectedMinimumReactions;
		private string _testWithName;
		private DateTime _lotUseDate;

		/// <summary>
		/// The list of columns
		/// </summary>
		public const string RACKLOTCOLUMNS = "RackLotGuid,SatisfactoryResultIndicator," + 
			"ReactivityPhaseText,ReactivityPhaseCode,ExpectedMinimumReactions,TestWithName,LotUseDate";

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2314"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>RackLot object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3301"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// RackLot identifier
		/// </summary>
		public RackLot()
		{

		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2416"> 
		///		<ExpectedInput>DataRow containing RackLot data</ExpectedInput>
		///		<ExpectedOutput>RackLot object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2870"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates RackLot object and populates it with data from DataRow
		/// </summary>
		/// <param name="dr"></param>
		public RackLot(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1514"> 
		///		<ExpectedInput>GUID</ExpectedInput>
		///		<ExpectedOutput>GUID</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3303"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// RackLot identifier
		/// </summary>
		public Guid RackLotGuid
		{
			get
			{
				return _rackLotGUID;
			}
			set
			{
				_rackLotGUID = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1308"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3304"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Name of test
		/// </summary>
		public string TestWithName
		{
			get
			{
				return this._testWithName;
			}
			set
			{
				this._testWithName = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1309"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3305"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Expected minimum reactions
		/// </summary>
		public string ExpectedMinimumReactions
		{
			get
			{
				return this._expectedMinimumReactions;
			}
			set
			{
				this._expectedMinimumReactions = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1310"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3312"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Reactivity Phase Text
		/// </summary>
		public string ReactivityPhaseText
		{
			get
			{
				return this._reactivityPhaseText;
			}
			set
			{
				this._reactivityPhaseText = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1311"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3313"> 
		///		<ExpectedInput>empty string</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Reactivity Phase Code
		/// Implements BR_41.02
		/// </summary>
		public string ReactivityPhaseCode
		{
			get
			{
				return this._reactivityPhaseCode;
			}
			set
			{
				this._reactivityPhaseCode = value;
				//
				RuleBroken(MethodBase.GetCurrentMethod().Name,((value==string.Empty)||(value==((int)Common.ReactivityPhase.Unknown).ToString())));
				//
				if (this._reactivityPhaseCode==((int)Common.ReactivityPhase.AHGandCC).ToString())
				{
					RuleBroken(TABLE.Rack.RackName,true);
				}
				else
				{
					RuleBroken(TABLE.Rack.RackName,false);
				}
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1317"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3314"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Test Result Indicator
		/// </summary>
		public bool SatisfactoryResultIndicator
		{
			get
			{
				return this._satisfactoryResultIndicator;
			}
			set
			{
				this._satisfactoryResultIndicator = value;
			}
		}
		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1318"> 
		///		<ExpectedInput>rack</ExpectedInput>
		///		<ExpectedOutput>rack</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3350"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Rack being tested
		/// </summary>
		public Rack Rack
		{
			get
			{
				return this._rack;
			}
			set
			{
				this._rack = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1319"> 
		///		<ExpectedInput>reagent</ExpectedInput>
		///		<ExpectedOutput>reagent</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3354"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Reagent
		/// </summary>
		public Reagent Reagent
		{
			get
			{
				return this._reagent;
			}
			set
			{
				this._reagent = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1515"> 
		///		<ExpectedInput>datetime</ExpectedInput>
		///		<ExpectedOutput>datetime</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="3361"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// The date of the last usage of the lot
		/// </summary>
		public DateTime LotUseDate
		{
			get
			{
				return _lotUseDate;
			}
			set
			{
				_lotUseDate = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1320"> 
		///		<ExpectedInput>TestResults DataTable, RackGuid, PartiallyTestedIndicator and division code</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1986"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Saves datatable of rack tests
		/// </summary>
		/// <param name="dtRackTestResults"></param>
		/// <param name="RackGuid"></param>
		/// <param name="rowVersion"></param>
		/// <param name="partiallyTested"></param>
		/// <param name="divisionCode"></param>
		/// <param name="lastUpdateFunctionId">UC or calling method</param>
		/// <param name="workloadProcessIds">workload process ids</param>
		/// <param name="testingTech">testing technician</param>
		/// <param name="testDateTime">date and time of test</param>
		/// <param name="dailyAlertTime">date and time of daily alert for qc</param>
		/// <param name="dailyQcWorklistGuid">daily qc worklist guid</param>
		/// <returns>boolean</returns>
		public static bool SaveRackTests(DataTable dtRackTestResults, Guid RackGuid, byte[] rowVersion, bool partiallyTested, string divisionCode, Common.UpdateFunction lastUpdateFunctionId, Common.WorkloadProcessID [] workloadProcessIds, string testingTech, DateTime testDateTime, DateTime dailyAlertTime, Guid dailyQcWorklistGuid)
		{
			DataTable dtExceptions = null;
			int nCount = 0;
			DataTable dtWorkloadEventsTotal = null;
			System.Data.DataTable[] dtWorkloadEvents = new System.Data.DataTable [workloadProcessIds.GetLength(0)];
			if(!partiallyTested)
			{
				System.Guid [] rackGuids = new System.Guid[1];
				rackGuids[0] = RackGuid;
			
				for (int nCtr = 0; nCtr < workloadProcessIds.GetLength(0); nCtr++)
				{
					dtWorkloadEvents[nCtr] = WorkloadEvent.GenerateWorkloadData(workloadProcessIds[nCtr], rackGuids, Common.WorkloadTransactionType.Miscellanious, false);
				}
				if(workloadProcessIds.GetLength(0) > 0)
				{
					dtWorkloadEventsTotal = dtWorkloadEvents[0].Clone();
					nCount = dtWorkloadEvents.GetLength(0);
					for(int nIndx = 0; nIndx < nCount; nIndx++)
					{
						DataTable dtWorkloadEventsCurrent = dtWorkloadEvents[nIndx];
						foreach(DataRow dtRow in dtWorkloadEventsCurrent.Rows)
						{
							DataRow dtNewRow = dtWorkloadEventsTotal.NewRow();
							dtNewRow.ItemArray = dtRow.ItemArray;
							dtWorkloadEventsTotal.Rows.Add(dtNewRow);
						}
					}
				}
			}
			DataTable dtRackTestsInsert = new DataTable();
			dtRackTestsInsert.Columns.Add(TABLE.RackTest.RackTestGuid, typeof(Guid));
			dtRackTestsInsert.Columns.Add(TABLE.RackTest.RackLotGuid, typeof(Guid));
			dtRackTestsInsert.Columns.Add(TABLE.RackTest.TestDate, typeof(DateTime));
			dtRackTestsInsert.Columns.Add(TABLE.RackTest.TestTechId);
			dtRackTestsInsert.Columns.Add(TABLE.RackTest.RackTestResult);
			dtRackTestsInsert.Columns.Add(TABLE.RackTest.RackTestResultTypeCode);
			dtRackTestsInsert.Columns.Add(TABLE.RackTest.DivisionCode);
			dtRackTestsInsert.Columns.Add(TABLE.RackTest.RecordStatusCode);
			//CR 2696
			dtRackTestsInsert.Columns.Add(TABLE.RackTest.TestWithReagentGuid, typeof(Guid));

			DataTable dtRackTestsUpdate = new DataTable();
			dtRackTestsUpdate.Columns.Add(TABLE.RackTest.RackTestGuid, typeof(Guid));
			dtRackTestsUpdate.Columns.Add(TABLE.RackTest.TestDate, typeof(DateTime));
			dtRackTestsUpdate.Columns.Add(TABLE.RackTest.TestTechId);
			dtRackTestsUpdate.Columns.Add(TABLE.RackTest.RackTestResult);
			dtRackTestsUpdate.Columns.Add(TABLE.RackTest.DivisionCode);
			dtRackTestsUpdate.Columns.Add(TABLE.RackTest.RecordStatusCode);
			dtRackTestsUpdate.Columns.Add(TABLE.RackTest.RowVersion, typeof(byte[]));

			DataTable dtRackLots = new DataTable();
			dtRackLots.Columns.Add(TABLE.RackTest.RackLotGuid, typeof(Guid));
			dtRackLots.Columns.Add(TABLE.Rack.RackGuid, typeof(Guid));
			dtRackLots.Columns.Add(TABLE.RackLot.ReagentGuid, typeof(Guid));
			dtRackLots.Columns.Add(TABLE.RackLot.TestWithName);
			dtRackLots.Columns.Add(TABLE.RackLot.TestWithId, typeof(int));
			dtRackLots.Columns.Add(TABLE.RackLot.LotVialNumber);
			dtRackLots.Columns.Add(TABLE.RackLot.ExpectedMinimumReactions);
			dtRackLots.Columns.Add(TABLE.RackLot.SatisfactoryResultIndicator, typeof(bool));
			dtRackLots.Columns.Add(TABLE.RackLot.ReactivityPhaseCode);
			dtRackLots.Columns.Add(TABLE.RackLot.LotUseDate, typeof(DateTime));
			dtRackLots.Columns.Add(TABLE.RackLot.DivisionCode);
			dtRackLots.Columns.Add(TABLE.RackLot.TestingMethodCode);
			dtRackLots.Columns.Add(TABLE.RackLot.DailyQcWorklistGuid, typeof(Guid));

			DataTable dtDailyQcWorklist = new DataTable();
			if (dailyQcWorklistGuid == Guid.Empty)
			{
				dtDailyQcWorklist.Columns.Add(TABLE.DailyQcWorklist.RackGuid, typeof(Guid));
				dtDailyQcWorklist.Columns.Add(TABLE.DailyQcWorklist.DailyQcExpirationDate, typeof(DateTime));
			}
			else
			{
				dtDailyQcWorklist.Columns.Add(TABLE.DailyQcWorklist.RowVersion, typeof(byte[]));
			}
			dtDailyQcWorklist.Columns.Add(TABLE.DailyQcWorklist.DivisionCode, typeof(string));
			dtDailyQcWorklist.Columns.Add(TABLE.DailyQcWorklist.DailyQcWorklistGuid, typeof(Guid));
			dtDailyQcWorklist.Columns.Add(TABLE.DailyQcWorklist.PartiallyTestedIndicator, typeof(bool));
			dtDailyQcWorklist.Columns.Add(TABLE.DailyQcWorklist.DailyUseIndicator, typeof(bool));
			
			DataRow dr = dtDailyQcWorklist.NewRow();
			if (dailyQcWorklistGuid == Guid.Empty)
			{
				dr[TABLE.DailyQcWorklist.DailyQcWorklistGuid] = Guid.NewGuid();
				dr[TABLE.DailyQcWorklist.RackGuid] = RackGuid;

				DateTime dailyQcExpirationDateTime = new DateTime();
				int testTime = testDateTime.Hour * 60 + testDateTime.Minute;
				int alertTime = dailyAlertTime.Hour * 60 + dailyAlertTime.Minute;

				//the test was performed before daily alert time (meaning that it will expire today)
				if (testTime - alertTime < 0)
				{
					dailyQcExpirationDateTime = new DateTime(testDateTime.Year, testDateTime.Month, testDateTime.Day, dailyAlertTime.Hour, dailyAlertTime.Minute, dailyAlertTime.Second);
				}
				else if ((testTime - alertTime >= 0) && (testTime - alertTime < 1440))
				{
					dailyQcExpirationDateTime = new DateTime(testDateTime.Year, testDateTime.Month, testDateTime.Day, dailyAlertTime.Hour, dailyAlertTime.Minute, dailyAlertTime.Second);
					dailyQcExpirationDateTime = dailyQcExpirationDateTime.AddDays(1);
				}
				else
				{
					dailyQcExpirationDateTime = new DateTime(testDateTime.Year, testDateTime.Month, testDateTime.Day, dailyAlertTime.Hour, dailyAlertTime.Minute, dailyAlertTime.Second);
					dailyQcExpirationDateTime = dailyQcExpirationDateTime.AddDays(2);
				}

				dr[TABLE.DailyQcWorklist.DailyQcExpirationDate] = dailyQcExpirationDateTime;
			}
			else
			{
				dr[TABLE.DailyQcWorklist.DailyQcWorklistGuid] = dailyQcWorklistGuid;
				dr[TABLE.DailyQcWorklist.RowVersion] = rowVersion;
			}

			dr[TABLE.DailyQcWorklist.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dr[TABLE.DailyQcWorklist.PartiallyTestedIndicator] = partiallyTested;
			dr[TABLE.DailyQcWorklist.DailyUseIndicator] = true;
			dtDailyQcWorklist.Rows.Add(dr);

			foreach(DataRow drRackTestResult in dtRackTestResults.Rows)
			{
				DataRow drRackLot = dtRackLots.NewRow();
				if ((bool)drRackTestResult["Insert"] == true)
				{
					drRackLot[TABLE.RackTest.RackLotGuid] = Guid.NewGuid();
					drRackLot[TABLE.RackLot.DailyQcWorklistGuid] = dtDailyQcWorklist.Rows[0][TABLE.DailyQcWorklist.DailyQcWorklistGuid];
					drRackLot[TABLE.Rack.RackGuid] = RackGuid;
					drRackLot[TABLE.RackLot.ReagentGuid] = drRackTestResult[TABLE.RackLot.ReagentGuid];
					drRackLot[TABLE.RackLot.TestWithName] = drRackTestResult[TABLE.RackLot.TestWithName];
					drRackLot[TABLE.RackLot.TestWithId] = drRackTestResult[TABLE.RackLot.TestWithId];
					drRackLot[TABLE.RackLot.LotVialNumber] = drRackTestResult["SetVialId"];
					drRackLot[TABLE.RackLot.ExpectedMinimumReactions] = drRackTestResult[TABLE.RackLot.ExpectedMinimumReactions];
					drRackLot[TABLE.RackLot.ReactivityPhaseCode] = drRackTestResult[TABLE.RackLot.ReactivityPhaseCode];
					drRackLot[TABLE.RackLot.ReactivityPhaseCode] = drRackTestResult[TABLE.RackLot.ReactivityPhaseCode];
					drRackLot[TABLE.RackLot.TestingMethodCode] = drRackTestResult[TABLE.RackLot.TestingMethodCode];

					if(drRackTestResult["TestResultIndicator"].ToString() == "S" &&
					   drRackTestResult.IsNull("ReagentExpiredException") == true)
					{
						drRackLot[TABLE.RackLot.SatisfactoryResultIndicator] = true;
					}
					else
					{
						drRackLot[TABLE.RackLot.SatisfactoryResultIndicator] = false;
					}
					drRackLot[TABLE.RackLot.LotUseDate] = testDateTime;
					drRackLot[TABLE.RackLot.DivisionCode] = divisionCode;
					dtRackLots.Rows.Add(drRackLot);
				}

				if ((bool)drRackTestResult["TestWithReagent"] == false)
				{
					DataRow drRackTest = null;
					bool update = false;
					string minimumResult = drRackTestResult["ExpectedMinimumReactions"].ToString().Trim();	// minimum result
					string testPhase = drRackTestResult["ReactivityPhaseText"].ToString().Trim();		// test phase code

					for(int i=0 ; i<3 ; i++)
					{
						if (i==0)
						{
							if ((bool)drRackTestResult["ReadOnlyIsResults"] == true ||
								testPhase.IndexOf(ARTIFICIAL.IS) == -1)
								continue;
							
							if (drRackTestResult.IsNull("IsGuid") == true)
							{
								drRackTest = dtRackTestsInsert.NewRow();
								drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.IS;
								drRackTest[TABLE.RackTest.RackTestGuid] = Guid.NewGuid();
								//CR 2696
								drRackTest[TABLE.RackTest.TestWithReagentGuid] = drRackTestResult[TABLE.RackTest.TestWithReagentGuid];
								update = false;
							}
							else
							{
								if (drRackTestResult[ARTIFICIAL.IsResults].ToString().Trim() == "")
									continue;

								drRackTest = dtRackTestsUpdate.NewRow();
								drRackTest[TABLE.RackTest.RackTestGuid] = drRackTestResult["IsGuid"];
								drRackTest[TABLE.RackTest.RowVersion] = drRackTestResult["IsRowVersion"];
								update = true;
							}
							if (drRackTestResult["TestResultIndicator"].ToString().ToUpper() != "U")
							{
								if (drRackTestResult[ARTIFICIAL.IsResults].ToString().Trim() != "")
								{
									drRackTest[TABLE.RackTest.RackTestResult] = drRackTestResult[ARTIFICIAL.IsResults];
								}
							}
						}
						else if (i==1)
						{
							if ((bool)drRackTestResult["ReadOnlyIatResults"] == true ||
								testPhase.IndexOf("IAT") == -1)
								continue;

							if (drRackTestResult.IsNull("IatGuid") == true)
							{
								drRackTest = dtRackTestsInsert.NewRow();
								drRackTest[TABLE.RackTest.RackTestResultTypeCode] = "IAT";
								drRackTest[TABLE.RackTest.RackTestGuid] = Guid.NewGuid();
								//CR 2696
								drRackTest[TABLE.RackTest.TestWithReagentGuid] = drRackTestResult[TABLE.RackTest.TestWithReagentGuid];
								update = false;
							}
							else
							{
								if (drRackTestResult[ARTIFICIAL.IatResults].ToString().Trim() == "")
									continue;

								drRackTest = dtRackTestsUpdate.NewRow();
								drRackTest[TABLE.RackTest.RackTestGuid] = drRackTestResult["IatGuid"];
								drRackTest[TABLE.RackTest.RowVersion] = drRackTestResult["IatRowVersion"];
								update = true;
							}
							if (drRackTestResult["TestResultIndicator"].ToString().ToUpper() != "U")
							{
								if (drRackTestResult[ARTIFICIAL.IatResults].ToString().Trim() != "")
								{
									drRackTest[TABLE.RackTest.RackTestResult] = drRackTestResult[ARTIFICIAL.IatResults];
								}
							}
						}
						else if (i==2)
						{
							if ((bool)drRackTestResult["ReadOnlyCcResults"] == true ||
								(testPhase.IndexOf("IAT") == -1) ||
								(testPhase.IndexOf("IAT") != -1 && minimumResult != "0") ||
								(testPhase.IndexOf("IAT") != -1 && minimumResult == "0" && drRackTestResult[ARTIFICIAL.IatResults].ToString().Trim() != "0" && drRackTestResult[ARTIFICIAL.IatResults].ToString().Trim() != ""))
								continue;

							if (drRackTestResult.IsNull("CcGuid") == true)
							{
								drRackTest = dtRackTestsInsert.NewRow();
								drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.CC;
								drRackTest[TABLE.RackTest.RackTestGuid] = Guid.NewGuid();
								//CR 2696
								drRackTest[TABLE.RackTest.TestWithReagentGuid] = drRackTestResult[TABLE.RackTest.TestWithReagentGuid];
								update = false;
							}
							else
							{
								if (drRackTestResult[ARTIFICIAL.CcResults].ToString().Trim() == "")
									continue;

								drRackTest = dtRackTestsUpdate.NewRow();
								drRackTest[TABLE.RackTest.RackTestGuid] = drRackTestResult["CcGuid"];
								drRackTest[TABLE.RackTest.RowVersion] = drRackTestResult["CcRowVersion"];
								update = true;
							}
							if (drRackTestResult["TestResultIndicator"].ToString().ToUpper() != "U")
							{
								if (drRackTestResult[ARTIFICIAL.CcResults].ToString().Trim() != "")
								{
									drRackTest[TABLE.RackTest.RackTestResult] = drRackTestResult[ARTIFICIAL.CcResults];
								}
							}
						}

                        //CR 3554
                        if (drRackTest == null)
                            throw new ApplicationException("drRackTest is null");
                        //*** Fortify Justified Code ***
                        //drRackTest can't be null since it is checked earler (see above). 
                        drRackTest[TABLE.RackTest.TestDate] = testDateTime;
						drRackTest[TABLE.RackTest.TestTechId] = testingTech;
						drRackTest[TABLE.RackTest.DivisionCode] = divisionCode;
						drRackTest[TABLE.RackTest.RecordStatusCode] = Common.RecordStatusCode.Active;
                        //*** Fortify Justified Code ***
                        if (update == false)
						{
							drRackTest[TABLE.RackLot.RackLotGuid] = drRackLot[TABLE.RackLot.RackLotGuid];
							dtRackTestsInsert.Rows.Add(drRackTest);
						}
						else
						{
							dtRackTestsUpdate.Rows.Add(drRackTest);
						}
					}
				}

				foreach (DataColumn dtCol in dtRackTestResults.Columns)
				{
					if (drRackTestResult[dtCol].GetType().ToString().IndexOf("ExceptionReport") != -1)
					{
						if (drRackTestResult.IsNull(dtCol) == false)
						{
							if (dtExceptions == null)
							{
								dtExceptions = ((BOL.ExceptionReport)drRackTestResult[dtCol]).ExceptionData.Table.Clone();
							}
                            //*** Fortify Justified Code ***
                            //dtExceptions can't be null since it is checked earler (see above). 
                            dtExceptions.Rows.Add(((BOL.ExceptionReport)drRackTestResult[dtCol]).ExceptionData.ItemArray);
                            //*** Fortify Justified Code ***
                        }
                    }
				}
			}
		
			return DAL.RackTest.SaveRackTests(dtRackTestsInsert, dtRackTestsUpdate, dtRackLots, dtDailyQcWorklist, dtExceptions, lastUpdateFunctionId, dtWorkloadEventsTotal, dailyQcWorklistGuid);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Fills the properties of the object from the values in the data row
		/// </summary>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			this.RackLotGuid = dtRow.IsNull(TABLE.RackLot.RackLotGuid) ? Guid.Empty : (System.Guid) dtRow[TABLE.RackLot.RackLotGuid];
			this.TestWithName = dtRow.IsNull(TABLE.RackLot.TestWithName) ? string.Empty : dtRow[TABLE.RackLot.TestWithName].ToString();
			this.ExpectedMinimumReactions = dtRow.IsNull(TABLE.RackLot.ExpectedMinimumReactions) ? string.Empty : dtRow[TABLE.RackLot.ExpectedMinimumReactions].ToString();
			this.ReactivityPhaseText = dtRow.IsNull(TABLE.ReactivityPhase.ReactivityPhaseText) ? string.Empty : dtRow[TABLE.ReactivityPhase.ReactivityPhaseText].ToString();
			this.ReactivityPhaseCode = dtRow.IsNull(TABLE.RackLot.ReactivityPhaseCode) ? string.Empty : dtRow[TABLE.RackLot.ReactivityPhaseCode].ToString();
			this.LotUseDate = dtRow.IsNull(TABLE.RackLot.LotUseDate) ? DateTime.MinValue : (System.DateTime) dtRow[TABLE.RackLot.LotUseDate];
			this.SatisfactoryResultIndicator = dtRow.IsNull(TABLE.RackLot.SatisfactoryResultIndicator) ? false : (bool) dtRow[TABLE.RackLot.SatisfactoryResultIndicator];
			this.IsNew = false;
		}




		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1517"> 
		///		<ExpectedInput>Valid DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow populated with object data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2871"> 
		///		<ExpectedInput>Invalid DataRow</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			dtRow[TABLE.RackLot.RackLotGuid] = this.RackLotGuid;
			dtRow[TABLE.RackLot.TestWithName] = this.TestWithName;
			dtRow[TABLE.RackLot.ExpectedMinimumReactions] = this.ExpectedMinimumReactions;
			dtRow[TABLE.ReactivityPhase.ReactivityPhaseText] = this.ReactivityPhaseText;
			dtRow[TABLE.RackLot.ReactivityPhaseCode] = this.ReactivityPhaseCode;
			dtRow[TABLE.RackLot.LotUseDate] = this.LotUseDate;
			dtRow[TABLE.RackLot.SatisfactoryResultIndicator] = this.SatisfactoryResultIndicator;

			return dtRow;
		}


		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3362"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3374"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get empty table schema for use when inserting/updating rack lots into the database
		/// </summary>
		/// <param name="insert">Insert Indicator. True if inserting, false if updating</param>
		/// <returns>Rack Lot table schema</returns>
		public static DataTable GetRackLotTableSchema(bool insert)
		{
			DataTable dt = new System.Data.DataTable(TABLE.RackLot.TableName);
			//
			if (insert)
			{
				dt.Columns.Add(TABLE.RackLot.RackGuid,typeof(Guid));
				dt.Columns.Add(TABLE.RackLot.TestWithName, typeof(string));
				dt.Columns.Add(TABLE.RackLot.ExpectedMinimumReactions, typeof(char));
				dt.Columns.Add(TABLE.RackLot.ReactivityPhaseCode,typeof(string));
			}
			else
			{
				dt.Columns.Add(TABLE.RackLot.RowVersion, typeof(byte[]));
			}
			dt.Columns.Add(TABLE.RackLot.LotVialNumber, typeof(string));
			dt.Columns.Add(TABLE.RackLot.RackLotGuid, typeof(Guid));
			dt.Columns.Add(TABLE.RackLot.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.RackLot.SatisfactoryResultIndicator, typeof(bool));
			dt.Columns.Add(TABLE.RackLot.LotUseDate,typeof(DateTime));
			dt.Columns.Add(TABLE.RackLot.DivisionCode,typeof(string));
			dt.Columns.Add(TABLE.RackLot.Comments,typeof(string));
			dt.Columns.Add(TABLE.RackLot.ControlCellId,typeof(bool));
			dt.Columns.Add(TABLE.RackLot.TestWithId,typeof(int));
			return dt;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/24/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3381"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3382"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Public function to indicate if the testing phase selection is valid
		/// for the reagent. i.e. has it ever been tested using the phase before?
		/// </summary>
		/// <returns>Valid indicator</returns>
		public bool IsReagentTestingPhaseCorrect()
		{
			//
			//BR_41.26
			if ((this.Reagent.ReagentGuid != Guid.Empty) && 
				(this.ReactivityPhaseCode != null) && 
				(this.ReactivityPhaseCode != "") && 
				(((int)Common.ReactivityPhase.Unknown).ToString() != this.ReactivityPhaseCode))
			{
				DataTable dtPreviousPhases = DAL.Reagent.GetPreviousTestingPhases(this.Reagent.ReagentGuid);
				//
				if (dtPreviousPhases.Rows.Count > 0)
				{
					bool match = false;
					//
					//Check if testing phase ever used before...
					foreach (DataRow dr in dtPreviousPhases.Rows)
					{
						if (dr[TABLE.RackLot.ReactivityPhaseCode].ToString() == this.ReactivityPhaseCode)
						{
							match = true;
							break;
						}
					}
					//
					if (!match)
					{
						return false;
					}
				}
			}
			return true;
		}
	}
}



